var jsArrary = [
    { url: '/sdk/sdk.js', position: 'body'},
    { url: '/sdk/sip.js', position: 'head'},
]

function getJS(url,position){
    // 初始的JS文件URL
    var initialScriptUrl = httpUrl.substring(0, httpUrl.lastIndexOf(':')) + url;
    // 备用的JS文件URL
    var fallbackScriptUrl = standbyUrl.substring(0, standbyUrl.lastIndexOf(':')); + url;
    
    // 创建一个新的script元素
    var script = document.createElement('script');
    script.src = initialScriptUrl;
    
    // 监听script元素的加载和错误事件
    script.onload = function() {
        console.log('Script loaded successfully.');
    }
    
    script.onerror = function() {
        console.error('Script loading failed, falling back to another URL.');
        
        // 清除之前的script元素（可选，如果页面上有多个script元素可能需要这样做）
        if (script.parentNode) {
            script.parentNode.removeChild(script);
        }
        
        // 创建一个新的script元素并设置备用的URL
        script = document.createElement('script');
        script.src = fallbackScriptUrl;
        
        // 再次监听加载和错误事件（可选，如果需要的话）
        script.onload = function() {
            console.log('Fallback script loaded successfully.');
        }
        
        script.onerror = function() {
            console.error('Fallback script loading also failed.');
        }
        
        // 将备用的script元素添加到页面中
        if (position == 'head'){
            document.head.appendChild(script);
        } else {
            document.body.appendChild(script);
        }
    }
    
    // 将初始的script元素添加到页面中
    if (position == 'head'){
        document.head.appendChild(script);
    } else {
        document.body.appendChild(script);
    }
}
for (let i=0;i<jsArrary.length;i++){
    getJS(jsArrary[i].url,jsArrary[i].position)
}