const WebSocket = require('ws');

const agentIds = range('90000001', 50000);
const companyCode = '000017';
const pwd = 'adminAa12.'
const socketUrl = 'ws://172.16.250.134:50000/msg/';
const linkobj = {
  "agent_id": companyCode + '_',
  "company_code": companyCode,
  "os": 'Windows'
};

const createWebSocketConnection = (agentId) => {
  const agentLinkobj = Object.assign({}, linkobj, { "agent_id": companyCode + '_' + agentId });
  const agentLinkobjBase64 = Buffer.from(JSON.stringify(agentLinkobj)).toString('base64');
  const socketUrlWithAgentLinkobj = socketUrl + agentLinkobjBase64;

  const wsClient = new WebSocket(socketUrlWithAgentLinkobj);

  wsClient.on('open', () => {
    sendHeartbeat(wsClient, agentId);
  });

  wsClient.on('message', (message) => {
    if(message.indexOf('心跳成功') > 0){
      return
    } else {
      console.log(`Agent ${agentId} received message: ${message} .....${+new Date()}` );
    }
  });

  wsClient.on('close', () => {
  });

  wsClient.on('error', (error) => {
  });
}

const sendHeartbeat = (wsClient, agentId) => {
  const ping = Object.assign({}, linkobj, { "agent_id": companyCode + '_' + agentId },{msg_type: 'ping'});
  let msgObj1 = {
    msg_type: 'checkin',
    agent_ip: '172.0.18.24',
    agent_pwd: pwd,
    start_status: 'FREE',
    ext_id: companyCode + '_' +agentId,
    req_id: agentId
  }
  const checkinObj = Object.assign({}, linkobj, { "agent_id": companyCode + '_' + agentId },msgObj1);
  wsClient.send(JSON.stringify(checkinObj), (error) => {
    console.log(checkinObj)
  });
  setInterval(() => {
    wsClient.send(JSON.stringify(ping), (error) => {
      if (error) {
        console.error(`Failed to send ping to Agent ${agentId}: ${error}`);
      } else {
        console.log(`Sent ping to Agent ${agentId}`);
      }
    });
  }, 10000); // 10 seconds
  // if (agentId%2 == 0){
  //   let msgObj = {
  //     msg_type: 'call',
  //     callee_number: companyCode + '_' + (agentId+1),
  //     out_line: 0,
  //     audio: 3,
  //     video: 0,
  //     pixels: '',
  //     max_ring_time: '',
  //     max_call_time: '',
  //     record_start: '',
  //     record_contact: '',
  //     is_stereo: '',
  //     ext_id: companyCode + '_' +agentId,
  //     file_name: '',
  //     req_id: agentId
  //   }
  //   const call = Object.assign({}, linkobj, { "agent_id": companyCode + '_' + agentId },msgObj);
  //   setTimeout(() => {
  //     wsClient.send(JSON.stringify(call), (error) => {
  //       // if (error) {
  //       //   console.error(`Failed to send ping to Agent ${agentId}: ${error}`);
  //       // } else {
  //       //   console.log(`Sent ping to Agent ${agentId}`);
  //       // }
  //     });
  //   }, 5000); // 10 seconds
  // }
  // setTimeout(() => {
  //   wsClient.send(JSON.stringify(checkinObj), (error) => {
  //     // if (error) {
  //     //   console.error(`Failed to send ping to Agent ${agentId}: ${error}`);
  //     // } else {
  //     //   console.log(`Sent ping to Agent ${agentId}`);
  //     // }
  //   });
  // }, 2000); // 10 seconds
}

// 创建10000个WebSocket连接
for (let i=0;i<agentIds.length;i++){
  setTimeout(()=>{
    createWebSocketConnection(agentIds[i])
  }, i * 10)
}

function range(start,count) {
  const array = [];
  for (let i = 0; i < count; i++) {
    let str = '0000' + i.toString()
    str = str.slice(-5)
    str = '900' + str
    array.push(str);
  }
  return array;
}