#! /bin/sh
verbose () {
	echo "${green}$@${normal}"
    save_log "[INFO] "$@
}
error () {
	echo "${red}$@${normal}"
    save_log "[ERR] "$@
}
warning () {
	echo "${yellow}$@${normal}"
    save_log "[WARNING] "$@
}

notice () {
	echo "${blue}$@${normal}"
    save_log "[NOTICE] "$@
}

execute_shell() {
    if [ $# -gt 0 ]; then
        verbose "执行命令 ["$@"]"
        echo $@|sh
    fi
}

# check for color support
if test -t 1; then
    # see if it supports colors...
    ncolors=$(tput colors)

    if test -n "$ncolors" && test $ncolors -ge 8; then
        normal="$(tput sgr0)"
        red="$(tput setaf 1)"
        green="$(tput setaf 2)"
        yellow="$(tput setaf 3)"
        blue="$(tput setaf 4)"
    fi
fi

index=1
index_log() {
    notice $index". "$1
    index=`expr $index + 1`
}

save_log(){
    str_tmp="`date +%Y-%m-%d_%H:%M:%S` "
    while [ $# -ge 1 ];do
        str_tmp="$str_tmp $1"
        shift
    done
    echo $str_tmp >>$run_path/log/update_`date +%Y-%m-%d`.log
}

run_path='/home/server/switch/update/freeswitch/cloudcc-acd-update-20250320'
bak_path="bak"
P=`pwd`

mkdir -p $run_path/log
verbose "==================================== 开始执行回退脚本 ===================================="

if [ $P != "$run_path" ];then
    error "请在["$run_path"]目录下执行脚本"
    exit
fi

# 1.结束所有通话
index_log "掐断当前FS所有通话."
execute_shell "/home/server/switch/freeswitch/bin/fs_cli -x hupall"

sleep 1
cd $bak_path

# 2.回退文件
index_log "拷贝备份文件到FS目录."
ls mod/ | awk '{print "\\cp -a mod/"$1 " /home/server/switch/freeswitch/mod/"}'
ls mod/ | awk '{print "\\cp -a mod/"$1 " /home/server/switch/freeswitch/mod/"}'|sh

ls lib/ | awk '{print "\\cp -a lib/"$1 " /home/server/switch/freeswitch/lib/"}'
ls lib/ | awk '{print "\\cp -a lib/"$1 " /home/server/switch/freeswitch/lib/"}'|sh

ls scripts/ | awk '{print "\\cp -a scripts/"$1 " /home/server/switch/freeswitch/scripts/"}'
ls scripts/ | awk '{print "\\cp -a scripts/"$1 " /home/server/switch/freeswitch/scripts/"}'|sh

ls autoload_configs/ | awk '{print "\\cp -a autoload_configs/"$1 " /home/server/switch/freeswitch/conf/autoload_configs/"}'
ls autoload_configs/ | awk '{print "\\cp -a autoload_configs/"$1 " /home/server/switch/freeswitch/conf/autoload_configs/"}'|sh

ls dialplan/ | awk '{print "\\cp -a dialplan/"$1 " /home/server/switch/freeswitch/conf/dialplan/"}'
ls dialplan/ | awk '{print "\\cp -a dialplan/"$1 " /home/server/switch/freeswitch/conf/dialplan/"}'|sh

ls bin/ | awk '{print "\\cp -a bin/"$1 " /home/server/switch/freeswitch/bin/"}'
ls bin/ | awk '{print "\\cp -a bin/"$1 " /home/server/switch/freeswitch/bin/"}'|sh

# 3.关闭进程
reboot_cmd=$(ps -ef|grep -v grep|grep -v gcc|grep -v vi|grep -v tail|grep -v opt|grep -v 1.10.9|grep freeswitch|grep home|grep ncwait)
if [ -n "$reboot_cmd" ]; then
    index_log "关闭进程 "$(echo $reboot_cmd| awk '{print "["$8"]"}').
    execute_shell $(echo $reboot_cmd| awk '{print "kill -9 "$2}')
else
    index_log "关闭freeswitch进程."
    warning "进程不存在."
fi

sleep 1
# 4.启动进程
index_log "等待contab自动拉起FS."
# execute_shell "/home/server/switch/freeswitch/bin/freeswitch -ncwait -nonat"

notice '回退成功，检查脚本日志是否异常并回归验证业务.'

notice "==================================== 回退脚本执行结束 ===================================="