#! /bin/sh
verbose () {
	echo "${green}$@${normal}"
    save_log "[INFO] "$@
}
error () {
	echo "${red}$@${normal}"
    save_log "[ERR] "$@
}
warning () {
	echo "${yellow}$@${normal}"
    save_log "[WARNING] "$@
}

notice () {
	echo "${blue}$@${normal}"
    save_log "[NOTICE] "$@
}

execute_shell() {
    if [ $# -gt 0 ]; then
        verbose "执行命令 ["$@"]"
        echo $@|sh
    fi
}

# check for color support
if test -t 1; then
    # see if it supports colors...
    ncolors=$(tput colors)

    if test -n "$ncolors" && test $ncolors -ge 8; then
        normal="$(tput sgr0)"
        red="$(tput setaf 1)"
        green="$(tput setaf 2)"
        yellow="$(tput setaf 3)"
        blue="$(tput setaf 4)"
    fi
fi

index=1
index_log() {
    notice $index". "$1
    index=`expr $index + 1`
}

save_log(){
    str_tmp="`date +%Y-%m-%d_%H:%M:%S` "
    while [ $# -ge 1 ];do
        str_tmp="$str_tmp $1"
        shift
    done
    echo $str_tmp >>$run_path/log/update_`date +%Y-%m-%d`.log
}

run_path='/home/server/switch/update/freeswitch/cloudcc-acd-update-20250320'
bak_path=$run_path/bak
P=`pwd`

mkdir -p $run_path/log
notice "==================================== 开始执行升级脚本 ===================================="
notice "此次升级内容如下:"
notice "    1.修复呼入号码变化规则."
notice "升级流程大致如下:"
notice "    1.lcc_call_in.lua."
verbose "..."

if [ $P != "$run_path" ];then
    error "请在["$run_path"]目录下执行脚本"
    exit
fi

execute_shell "rm -rf update"

# 1.解压升级文件
index_log "解压升级文件."
execute_shell "unzip update.zip"

cd update

# 2.备份文件
if [ ! -d "$bak_path" ]; then
    index_log "备份文件 ->$bak_path".
    mkdir -p $bak_path
    mkdir -p $bak_path"/mod"
    mkdir -p $bak_path"/lib"
    mkdir -p $bak_path"/scripts"
    mkdir -p $bak_path"/autoload_configs"
    mkdir -p $bak_path"/dialplan"
    mkdir -p $bak_path"/bin"

    ls mod/ | awk -v path="$bak_path" '{print "\\cp -a /home/server/switch/freeswitch/mod/"$1" "path"/mod"}'
    ls mod/ | awk -v path="$bak_path" '{print "\\cp -a /home/server/switch/freeswitch/mod/"$1" "path"/mod"}'|sh

    ls lib/ | awk -v path="$bak_path" '{print "\\cp -a /home/server/switch/freeswitch/lib/"$1" "path"/lib"}'
    ls lib/ | awk -v path="$bak_path" '{print "\\cp -a /home/server/switch/freeswitch/lib/"$1" "path"/lib"}'|sh

    ls scripts/ | awk -v path="$bak_path" '{print "\\cp -a /home/server/switch/freeswitch/scripts/"$1" "path"/scripts"}'
    ls scripts/ | awk -v path="$bak_path" '{print "\\cp -a /home/server/switch/freeswitch/scripts/"$1" "path"/scripts"}'|sh

    ls autoload_configs/ | awk -v path="$bak_path" '{print "\\cp -a /home/server/switch/freeswitch/conf/autoload_configs/"$1" "path"/autoload_configs"}'
    ls autoload_configs/ | awk -v path="$bak_path" '{print "\\cp -a /home/server/switch/freeswitch/conf/autoload_configs/"$1" "path"/autoload_configs"}'|sh

    ls dialplan/ | awk -v path="$bak_path" '{print "\\cp -a /home/server/switch/freeswitch/conf/dialplan/"$1" "path"/dialplan"}'
    ls dialplan/ | awk -v path="$bak_path" '{print "\\cp -a /home/server/switch/freeswitch/conf/dialplan/"$1" "path"/dialplan"}'|sh

    ls bin/ | awk -v path="$bak_path" '{print "\\cp -a /home/server/switch/freeswitch/bin/"$1" "path"/bin"}'
    ls bin/ | awk -v path="$bak_path" '{print "\\cp -a /home/server/switch/freeswitch/bin/"$1" "path"/bin"}'|sh
else
    warning "备份文件已存在，略过备份."
fi

# 3.结束所有通话
index_log "掐断当前FS所有通话."
execute_shell "/home/server/switch/freeswitch/bin/fs_cli -x hupall"

sleep 1

# 4.升级文件
index_log "拷贝升级文件到FS目录."

ls mod/ | awk '{print "chmod 755 mod/"$1}'
ls mod/ | awk '{print "chmod 755 mod/"$1}'|sh
ls mod/ | awk -v path="$bak_path" '{print "\\cp -a mod/"$1 " /home/server/switch/freeswitch/mod/"}'
ls mod/ | awk -v path="$bak_path" '{print "\\cp -a mod/"$1 " /home/server/switch/freeswitch/mod/"}'|sh

ls lib/ | awk '{print "chmod 755 lib/"$1}'
ls lib/ | awk '{print "chmod 755 lib/"$1}'|sh
ls lib/ | awk -v path="$bak_path" '{print "\\cp -a lib/"$1 " /home/server/switch/freeswitch/lib/"}'
ls lib/ | awk -v path="$bak_path" '{print "\\cp -a lib/"$1 " /home/server/switch/freeswitch/lib/"}'|sh

ls scripts/ | awk -v path="$bak_path" '{print "\\cp -a scripts/"$1 " /home/server/switch/freeswitch/scripts/"}'
ls scripts/ | awk -v path="$bak_path" '{print "\\cp -a scripts/"$1 " /home/server/switch/freeswitch/scripts/"}'|sh

ls autoload_configs/ | awk -v path="$bak_path" '{print "\\cp -a autoload_configs/"$1 " /home/server/switch/freeswitch/conf/autoload_configs/"}'
ls autoload_configs/ | awk -v path="$bak_path" '{print "\\cp -a autoload_configs/"$1 " /home/server/switch/freeswitch/conf/autoload_configs/"}'|sh

ls dialplan/ | awk -v path="$bak_path" '{print "\\cp -a dialplan/"$1 " /home/server/switch/freeswitch/conf/dialplan/"}'
ls dialplan/ | awk -v path="$bak_path" '{print "\\cp -a dialplan/"$1 " /home/server/switch/freeswitch/conf/dialplan/"}'|sh

ls bin/ | awk '{print "chmod 755 bin/"$1}'
ls bin/ | awk '{print "chmod 755 bin/"$1}'|sh
ls bin/ | awk -v path="$bak_path" '{print "\\cp -a bin/"$1 " /home/server/switch/freeswitch/bin/"}'
ls bin/ | awk -v path="$bak_path" '{print "\\cp -a bin/"$1 " /home/server/switch/freeswitch/bin/"}'|sh

# 有些环境有软链接问题，这里处理下，保证成功更新
cd /home/server/switch/freeswitch/lib/
ln -sf libfreeswitch.so.1.0.0 libfreeswitch.so.1
ln -sf libfreeswitch.so.1.0.0 libfreeswitch.so

ln -sf libsofia-sip-ua.so.0.6.0 libsofia-sip-ua.so.0
ln -sf libsofia-sip-ua.so.0.6.0 libsofia-sip-ua.so

# 5.关闭进程
reboot_cmd=$(ps -ef|grep -v grep|grep -v gcc|grep -v vi|grep -v tail|grep -v opt|grep -v 1.10.9|grep freeswitch|grep home|grep ncwait)
if [ -n "$reboot_cmd" ]; then
    index_log "关闭进程 "$(echo $reboot_cmd| awk '{print "["$8"]"}').
    execute_shell $(echo $reboot_cmd| awk '{print "kill -9 "$2}')
else
    index_log "关闭freeswitch进程."
    warning "进程不存在."
fi

# 6.启动进程
index_log "等待contab自动拉起FS."
# sleep 1
# execute_shell "/home/server/switch/freeswitch/bin/freeswitch -ncwait -nonat"

notice '更新完成，检查脚本日志是否异常并回归验证业务.'

notice "==================================== 升级脚本执行结束 ===================================="